/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.NetworkParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class NetworkNodeParameter
extends BlockParameter
implements NetworkParameter {
    private static final long serialVersionUID = -81260807389046685L;
    private boolean fSlaveSelected;
    private boolean fDiagnosticSelected;
    private int fVMAddress;
    private int fBitNumber;
    private String fIPAddress;
    private int fNumberType;
    private int fBlockNumber;
    private int fDiagnosticType = 255;

    public NetworkNodeParameter() {
    }

    public NetworkNodeParameter(Block block) {
        super(block);
    }

    public boolean getValue() {
        int bitAdd;
        int vmAdd;
        if (this.fInterpreter == null) {
            return false;
        }
        if (this.isForSlave()) {
            vmAdd = this.getBlock().getHardware().getIntProperty("nStartAddress") + (this.getBlock().getNumber() - 1) / 8;
            bitAdd = (8 - this.getBlock().getNumber() % 8) % 8;
        } else {
            vmAdd = this.fVMAddress;
            bitAdd = this.fBitNumber;
        }
        return Util.getBit(this.fInterpreter.readVM(1, vmAdd), bitAdd) != 0;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(" \n");
        if (this.isForSlave()) {
            if (this.getConfiguredBlockNumber() > 0) {
                buffer.append("Slave: " + this.fIPAddress + " \n");
                buffer.append("Block: " + this.getBlockAbbreviation(this.getConfiguredBlockType()) + this.getConfiguredBlockNumber());
            }
        } else if (this.isForDiagnostic()) {
            buffer.append("Diagnostic: \n" + this.getDiagnosticTypeString());
        } else {
            buffer.append(this.getAddressText());
        }
        return buffer.toString();
    }

    private String getDiagnosticTypeString() {
        String ret = "";
        if (this.fDiagnosticType == 0) {
            ret = Language.getString("panel.diagnostic.networkAccessErr");
        } else if (this.fDiagnosticType == 1) {
            ret = Language.getString("panel.diagnostic.emBusErr");
        } else if (this.fDiagnosticType == 2) {
            ret = Language.getString("panel.diagnostic.sdCardRWErr");
        } else if (this.fDiagnosticType == 3) {
            ret = Language.getString("panel.diagnostic.sdCardWriteProtectionErr");
        }
        return ret;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.isForSlave()) {
            dw.writeBoolean(true);
            dw.writeBoolean(false);
            dw.writeString(this.getAddress());
            dw.writeInt(this.getConfiguredBlockType());
            dw.writeInt(this.getConfiguredBlockNumber());
        } else if (this.isForDiagnostic()) {
            dw.writeBoolean(false);
            dw.writeBoolean(true);
            dw.writeInt(this.getVMAddress());
            dw.writeInt(this.getBitNumber());
        } else {
            dw.writeBoolean(false);
            dw.writeBoolean(false);
            dw.writeInt(this.getVMAddress());
            dw.writeInt(this.getBitNumber());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setForSlave(dr.readBoolean());
        this.setForDiagnostic(dr.readBoolean());
        if (this.isForSlave()) {
            this.setAddress(dr.readString());
            this.setConfiguredBlockType(dr.readInt());
            this.setConfiguredBlockNumber(dr.readInt());
        } else {
            this.setVMAddress(dr.readInt());
            this.setBitNumber(dr.readInt());
            if (this.isForDiagnostic()) {
                this.setConfiguredDiagnosticType(this.getBitNumber());
            }
        }
    }

    public boolean isForSlave() {
        return this.fSlaveSelected;
    }

    public boolean isForDiagnostic() {
        return this.fDiagnosticSelected;
    }

    public void setForSlave(boolean selected) {
        this.fSlaveSelected = selected;
    }

    public void setForDiagnostic(boolean selected) {
        this.fDiagnosticSelected = selected;
    }

    public int getBitNumber() {
        return this.fBitNumber;
    }

    public void setBitNumber(int bitNumber) {
        this.fBitNumber = bitNumber;
    }

    public String getAddress() {
        if (this.fIPAddress == null) {
            this.fIPAddress = "";
        }
        return this.fIPAddress;
    }

    public void setAddress(String address) {
        this.fIPAddress = address;
    }

    public int getVMAddress() {
        return this.fVMAddress;
    }

    public void setVMAddress(int address) {
        this.fVMAddress = address;
    }

    public int getConfiguredBlockNumber() {
        return this.fBlockNumber;
    }

    public void setConfiguredBlockNumber(int blockNumber) {
        this.fBlockNumber = blockNumber;
    }

    public int getConfiguredBlockType() {
        return this.fNumberType;
    }

    public void setConfiguredBlockType(int blockType) {
        this.fNumberType = blockType;
    }

    public void setConfiguredDiagnosticType(int diagnosticType) {
        this.fDiagnosticType = diagnosticType;
    }

    public int getConfiguredDiagnosticType() {
        return this.fDiagnosticType;
    }

    public String getBlockAbbreviation(int numberType) {
        if (6 == numberType) {
            return "I";
        }
        if (7 == numberType) {
            return "Q";
        }
        if (10 == numberType) {
            return "M";
        }
        return "";
    }

    public String getAddressText() {
        return "V" + this.getVMAddress() + "." + this.getBitNumber();
    }

    public boolean isReadOP() {
        return true;
    }
}

